DELIMITER $$
DROP PROCEDURE IF EXISTS V20200521193954__Create_Payment_plan_Schedule $$
CREATE PROCEDURE V20200521193954__Create_Payment_plan_Schedule()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_schedule')) THEN 
CREATE TABLE `payment_plan_schedule` (
  `id` bigint NOT NULL,
  `paymentPlanId` bigint NOT NULL,
  `amountType` varchar(255) NOT NULL,
  `amount` double(20,2) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_payment_plan_schedule_to_payment_plan_idx` (`paymentPlanId`),
  KEY `fk_payment_plan_schedule_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_payment_plan_schedule_to_payment_plan` FOREIGN KEY (`paymentPlanId`) REFERENCES `payment_plan` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_schedule_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20200521193954__Create_Payment_plan_Schedule () $$ 
DROP PROCEDURE IF EXISTS V20200521193954__Create_Payment_plan_Schedule $$ 
DELIMITER ;