DELIMITER $$

DROP PROCEDURE IF EXISTS V20200605130710__Insert_admissionCycle $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200605130710__Insert_admissionCycle()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='FORM_SUBMISSION_STATUS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','FORM_SUBMISSION_STATUS','Form Submission Status','Form Submission Status',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='ADMISSION_OFFER_STATUS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('ADMISSION','ADMISSION_OFFER_STATUS','Admission Offer Status','Admission Offer Status',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V20200605130710__Insert_admissionCycle() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200605130710__Insert_admissionCycle $$
 
DELIMITER ;