DELIMITER $$
DROP PROCEDURE IF EXISTS V20200618162758__Create_Learning_Target $$
CREATE PROCEDURE V20200618162758__Create_Learning_Target()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target' )) THEN 

CREATE TABLE `learning_target` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `reviewDate` DATE NOT NULL,
  `nextReviewDate` DATE NULL DEFAULT NULL,
  `facultyComment` VARCHAR(1000) NULL DEFAULT NULL,
  `studentComment` VARCHAR(1000) NULL DEFAULT NULL,
  `admissionId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_learning_admissionId_idx` (`admissionId` ASC),
  INDEX `fk_learning_periodId_idx` (`periodId` ASC),
  INDEX `fk_learning_target_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_learning_target_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_learning_target_periodId`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_learning_target_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);


END IF; 

END $$
CALL V20200618162758__Create_Learning_Target () $$ 
DROP PROCEDURE IF EXISTS V20200618162758__Create_Learning_Target $$ 
DELIMITER ;