DELIMITER $$
DROP PROCEDURE IF EXISTS V20200629200244__Update_dataproviderMultiLanguage $$
CREATE PROCEDURE V20200629200244__Update_dataproviderMultiLanguage()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT')) THEN 
SET @clinicDtProviderId1=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code AS LANGUAGE_KEY,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
		INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId        
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId        
		LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
     
        INNER JOIN
   students st ON st.userId = stu.id
       INNER JOIN
   persons stuPer ON stuPer.id = st.personId
	LEFT JOIN
    multi_language ml on stuPer.correspondence_language = ml.id
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'CLINIC'" WHERE `dataProviderId`=@clinicDtProviderId1; 
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200629200244__Update_dataproviderMultiLanguage () $$
DROP PROCEDURE IF EXISTS V20200629200244__Update_dataproviderMultiLanguage $$
DELIMITER ;