DELIMITER $$

DROP PROCEDURE IF EXISTS V20200629203850__CreateEconomicInformation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200629203850__CreateEconomicInformation()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='economic_information' )) THEN
    
	CREATE TABLE `economic_information` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `person_Id` bigint(20) DEFAULT NULL,
	  `applicant_person_id` bigint(20) DEFAULT NULL,
	  `parent_qualification1` VARCHAR(50) DEFAULT NULL,
	  `parent_qualification2` VARCHAR(50) DEFAULT NULL,
	  `school_fee_per_year` VARCHAR(50) DEFAULT NULL,
	  `is_scholarship` VARCHAR(50) DEFAULT NULL,
	  `received_child_benefit` VARCHAR(50) DEFAULT NULL,
	  `social_pension` VARCHAR(50) DEFAULT NULL,
	  `pay_study` VARCHAR(50) DEFAULT NULL,
	  `NSFAS_holder` BIT(1) DEFAULT NULL,
	  `parent_annual_income` VARCHAR(50) DEFAULT NULL,
	  `parent_occupation` VARCHAR(50) DEFAULT NULL,
	  `employer` VARCHAR(50) DEFAULT NULL,
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	 
	  PRIMARY KEY (`id`),
	  KEY `fk_economic_information_person` (`person_Id`),
	  KEY `fk_economic_information_user` (`lastUpdatedBy`),
	  KEY `fk_economic_information_applicantperson` (`applicant_person_id`),
	  CONSTRAINT `fk_economic_information_person_Id` FOREIGN KEY (`person_Id`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
	  CONSTRAINT `Ref_economic_information_applicant_person_id` FOREIGN KEY (`applicant_person_id`) REFERENCES `applicant_person` (`id`),
	  CONSTRAINT `Ref_economic_information_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
	);
	
  END IF ;

END $$

-- Execute the stored procedure
CALL V20200629203850__CreateEconomicInformation $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200629203850__CreateEconomicInformation $$
 
DELIMITER ;
