DELIMITER $$
DROP PROCEDURE IF EXISTS V20200720123943__Insert_DataGridForJobPosting $$
CREATE PROCEDURE V20200720123943__Insert_DataGridForJobPosting()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.hrRecruitmentProcess.jobPosting.JobPostingGrid')) THEN 
INSERT INTO `data_grid`
(
`gridName`,
`portalId`,
`jsonObject`,
`lastUpdate`,
`lastUpdatedBy`)
VALUES
(
'Academia.view.hrRecruitmentProcess.jobPosting.JobPostingGrid',
1,
'[{"id": null,"columnName": "JOB_CODE","dataIndex": "jobCode","columnVisibility": "SHOW","sequence": 1,"mandatory": false}, 
{"id": null,"columnName": "JOB_TITLE","dataIndex": "jobTitle","columnVisibility": "SHOW","sequence": 2,"mandatory": false},
 {"id": null,"columnName": "PLACEMENT_JOB_COORDINATOR","dataIndex": "coordinator","columnVisibility": "SHOW","sequence": 3,"mandatory": false}, 
 {"id": null,"columnName": "FROM_DATE","dataIndex": "fromDate","columnVisibility": "SHOW","sequence": 4,"mandatory": false}, 
 {"id": null,"columnName": "TO_DATE","dataIndex": "toDate","columnVisibility": "SHOW","sequence": 5,"mandatory": false}, 
 {"id": null,"columnName": "PLACEMENT_JOB_NO_OF_POSITIONS","dataIndex": "noOfPositions","columnVisibility": "SHOW","sequence": 6,"mandatory": false}, 
 {"id": null,"columnName": "NO_OF_ACADEMY_LOCATIONS","dataIndex": "noOfAcademyLocations","columnVisibility": "SHOW","sequence": 7,"mandatory": false}, 
 {"id": null,"columnName": "PUBLISH_STATUS","dataIndex": "publishStatus","columnVisibility": "SHOW","sequence": 8,"mandatory": false}, 
 {"id": null,"columnName": "JOB_MAPPING_STATUS","dataIndex": "mappingStatus","columnVisibility": "SHOW","sequence": 9,"mandatory": false}, 
 {"id": null,"columnName": "STATUS","dataIndex": "status","columnVisibility": "SHOW","sequence": 10,"mandatory": false}]',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='JOB_MAPPING_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','JOB_MAPPING_STATUS','Mapping Status','Mapping Status',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PLACEMENT_JOB_COORDINATOR')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PLACEMENT_JOB_COORDINATOR','Coordinator','Coordinator',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='PLACEMENT_JOB_NO_OF_POSITIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','PLACEMENT_JOB_NO_OF_POSITIONS','No. of Positions','No. of Positions',now(),1);
END IF;

END $$
CALL V20200720123943__Insert_DataGridForJobPosting() $$
DROP PROCEDURE IF EXISTS V20200720123943__Insert_DataGridForJobPosting $$
DELIMITER ;
