DELIMITER $$

DROP PROCEDURE IF EXISTS V20200808115308__InsertUITRNSForFeePyerPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200808115308__InsertUITRNSForFeePyerPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
 
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FEE_EMAIL_HOME')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FEE_EMAIL_HOME','Email (Home)','Email (Home)','E-pos (tuis)', 'Email (Trang chủ)',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FEE_EMAIL_WORK')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FEE_EMAIL_WORK','Email (Work)','Email (Work)','E-pos (werk)', 'Email (Cơ quan)',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='EXAM_MAXIMUM_LIMIT_REACHED')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','EXAM_MAXIMUM_LIMIT_REACHED','Exam pass max limit has been reached','Exam pass max limit has been reached','Die maksimum limiet vir die eksamen slaag is bereik', 'Đã đạt đến giới hạn tối đa vượt qua bài kiểm tra',now(),1);
END IF;
 
END $$

-- Execute the stored procedure
CALL V20200808115308__InsertUITRNSForFeePyerPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200808115308__InsertUITRNSForFeePyerPortal $$
 
DELIMITER ;