DELIMITER $$
DROP PROCEDURE IF EXISTS V20200811133959__CreateSignupAditionalSetup $$
CREATE PROCEDURE V20200811133959__CreateSignupAditionalSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='signup_additional_setup')) THEN 
CREATE TABLE signup_additional_setup (
    id BIGINT(20) AUTO_INCREMENT primary key,
    guideline TEXT DEFAULT NULL,
    email_verification TINYINT(1) DEFAULT NULL,
    sms_verification TINYINT(1) DEFAULT NULL,
    captcha_verification TINYINT(1) DEFAULT NULL,
    logo_path VARCHAR(255) DEFAULT NULL,
    document_path VARCHAR(255) DEFAULT NULL,
    academy_location_id BIGINT(20) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    
    CONSTRAINT fk_signup_additional_setup_user
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id),
        
	CONSTRAINT fk_signup_additional_setup_academy_locations
	FOREIGN KEY (academy_location_id) 
	REFERENCES academy_location(id)
);
END IF; 

END $$
CALL V20200811133959__CreateSignupAditionalSetup() $$ 
DROP PROCEDURE IF EXISTS V20200811133959__CreateSignupAditionalSetup $$ 
DELIMITER ;