DELIMITER $$
DROP PROCEDURE IF EXISTS V20200817184150__Create_SchoolStudiesSectionRecommendation $$
CREATE PROCEDURE V20200817184150__Create_SchoolStudiesSectionRecommendation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='post_school_studies_recommendation')) THEN 
CREATE TABLE `post_school_studies_recommendation`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`post_school_studies_section_id` BIGINT(20) NULL DEFAULT NULL,
`eligibility_recommendation_id` BIGINT(20) NULL DEFAULT NULL,
`recommended_for_id` BIGINT(20) NULL DEFAULT NULL,
`lastUpdatedBy` BIGINT(20) NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
  	    KEY `fk_post_school_studies_recom_post_school` (`post_school_studies_section_id`),
	     KEY `fk_post_school_studies_recom_eligibility_recommendation` (`eligibility_recommendation_id`),
	      KEY `fk_post_school_studies_recom_recommended_for` (`recommended_for_id`),
	       
CONSTRAINT `fk_post_school_studies_recom_post_school`
  FOREIGN KEY (`post_school_studies_section_id`)
  REFERENCES `post_school_studies_section` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,

CONSTRAINT `fk_post_school_studies_recom_eligibility_recommendation`
  FOREIGN KEY (`eligibility_recommendation_id`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,

CONSTRAINT `fk_post_school_studies_recom_recommended_for`
  FOREIGN KEY (`recommended_for_id`)
  REFERENCES `programs` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION
  );
END IF; 

END $$
CALL V20200817184150__Create_SchoolStudiesSectionRecommendation () $$ 
DROP PROCEDURE IF EXISTS V20200817184150__Create_SchoolStudiesSectionRecommendation $$ 
DELIMITER ;