DELIMITER $$
DROP PROCEDURE IF EXISTS V20200818181200__Create_term_wise_course_registration $$
CREATE PROCEDURE V20200818181200__Create_term_wise_course_registration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()   AND table_name='term_wise_course_registration')) THEN 
CREATE TABLE `term_wise_course_registration` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` BIGINT(20) NOT NULL,
  `registrationTermId` BIGINT(20) NOT NULL,
  `adminStartDateTime` DATETIME NOT NULL,
  `adminEndDateTime` DATETIME NOT NULL,
  `studentStartDateTime` DATETIME NOT NULL,
  `studentEndDateTime` DATETIME NOT NULL,
  `whetherAllowAdd` BIT(1) NOT NULL DEFAULT b'0',
  `whetherAllowDrop` BIT(1) NOT NULL DEFAULT b'0',
  `whetherAllowLateFee` BIT(1) NOT NULL DEFAULT b'0',
	`lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
	INDEX `fk_registration_term_setup_detail_idx1` (`registrationTermSetupDetailId` ASC),
	CONSTRAINT `fk1_registration_term_setup_detail`
    FOREIGN KEY (`registrationTermSetupDetailId`)
    REFERENCES `registration_term_setup_detail` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	INDEX `fk_registration_term_idx` (`registrationTermId` ASC),
	CONSTRAINT `fk_registration_term`
    FOREIGN KEY (`registrationTermId`)
    REFERENCES `registration_term` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200818181200__Create_term_wise_course_registration () $$ 
DROP PROCEDURE IF EXISTS V20200818181200__Create_term_wise_course_registration $$ 
DELIMITER ;