DELIMITER $$
DROP PROCEDURE IF EXISTS V20200828211542__Alter_SubjectAddEqvlntSubject $$
CREATE PROCEDURE V20200828211542__Alter_SubjectAddEqvlntSubject()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='subjects' 
		AND column_name='equivalentSubjectId')) THEN 
		
		ALTER TABLE `subjects` 
		ADD COLUMN `equivalentSubjectId` BIGINT NULL DEFAULT NULL AFTER `examBoardType`,
		ADD CONSTRAINT `fk_exam_board_master_equivalentSubjectId` FOREIGN KEY (`equivalentSubjectId`) REFERENCES `subjects` (`id`);
		
	END IF;
		
	SET @standardMasterId=(SELECT MAX(id) FROM standard_master where tableName='subjects' AND masterName='SUBJECT');
		
	IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE dbFieldName = 'equivalentSubjectId' AND standardMasterId = @standardMasterId)) THEN 
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`,  
		  `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, 
		  `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1, 'equivalentSubjectId', 'EQUIVALENT_SUBJECT', @standardMasterId, 'Varchar', '4', 1, 'subjects', 'id', 
		 'value', 0, 0, 1, '1', SYSDATE());
	
	END IF;
	
END $$

CALL V20200828211542__Alter_SubjectAddEqvlntSubject() $$
DROP PROCEDURE IF EXISTS V20200828211542__Alter_SubjectAddEqvlntSubject $$
DELIMITER ;
