DELIMITER $$
DROP PROCEDURE IF EXISTS V20200910141310__Create_CourseMultipleLanguage $$
CREATE PROCEDURE V20200910141310__Create_CourseMultipleLanguage()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE()  AND table_name='course_multiple_language')) THEN 
CREATE TABLE `course_multiple_language` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT(20) NOT NULL,
  `multiLanguageId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_multiple_language_1_idx` (`courseId` ASC),
  INDEX `fk_course_multiple_language_2_idx` (`multiLanguageId` ASC),
  INDEX `fk_course_multiple_language_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_multiple_language_1`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_multiple_language_2`
    FOREIGN KEY (`multiLanguageId`)
    REFERENCES `multi_language` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_multiple_languages_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT)
    ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200910141310__Create_CourseMultipleLanguage () $$ 
DROP PROCEDURE IF EXISTS V20200910141310__Create_CourseMultipleLanguage $$ 
DELIMITER ;