DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_programmeenrolmentdetails //
CREATE  PROCEDURE sp_tvet_programmeenrolmentdetails()
BEGIN

select per.nationalID as National_Id,
iddetail.idNumber as Person_Alternate_Id,
iddetail.itemCode as Alternate_Id_Type_Id,
prog.programRegistrationId as Qualification_Id,
case when progbs.exitDate is not null then 10 else 3 end as Enrolment_Status_Id,
'' as Filler01,modo.itemCode as Enrolment_Type_Id,
case when progbs.exitDate is not null then progbs.exitDate else progbs.entryDate end Enrolment_Status_Date,
progbs.entryDate as Enrolment_Date,
'' as Filler02,aaw.itemCode as Part_Of_Id,
case when aaw.itemCode='3' then prog.programRegistrationId else '' end Learnership_Id,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
'' as Filler03,
prog.programCode as Programme_Code,
'' as Enrolment_Status_Reason_Id,
progbs.entryDate as Most_Recent_Registration_Date,
'' as Certificate_Number,
.49 as Instutional_Housing_FTEInstutional_Housing_FTE,
case when per.nationalID is not null then 3 else 1 end as Entrance_Category_Id,
dom.id as Previous_Activity_Id,
rt.itemCode as Enrolment_Mode_Id,
stus.itemCode as Economic_Status_Id,
au.itemCode as Partnership_Id,
'' as SDL_No, -- CF1 from Training Details of Student
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
 from
program_batch_students progbs
join batches btc  on(progbs.programBatchId=btc.id)
join programs prog on(prog.id=btc.programId)
join admission adm on (progbs.admissionId=adm.id)
join students stu on(stu.userId=adm.studentId)
join persons per on(per.id=stu.personId)
join mode_of_delivery modo on(btc.modeOfDeliveryId=modo.id)
left join academic_award aaw on(aaw.id=prog.academicAwardId)
join academy_location al on(al.id=prog.academyLocationId)
join locations loc on(loc.id=al.locationId)
left join registration_type rt on(prog.registrationTypeId=rt.id)
left join  domicile dom on(dom.id=per.domicileId)
left join  student_status stus on(stus.id=per.studentStatusId)
left join affiliated_university au on(au.id=prog.affiliatedUniversityId)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
where year(now()) between year(btc.startDate) and year(btc.tillDate) group by progbs.id;

END//
DELIMITER ;