DELIMITER $$
DROP PROCEDURE IF EXISTS V20201209132257__Update_CopyDataOfEnquirySubject $$
CREATE PROCEDURE V20201209132257__Update_CopyDataOfEnquirySubject()
BEGIN
 
	IF EXISTS ((SELECT * FROM `exam_board_master` WHERE `itemValue` = 'Others')) THEN 
		SET @examBoardOtherId = (SELECT id FROM `exam_board_master` WHERE `itemValue` ='Others');
		
		IF EXISTS ((SELECT * FROM `subjects` WHERE `itemValue` ='Mathematics' and `examBoardType`= @examBoardOtherId)) THEN
			SET @mathematicsId = (SELECT id FROM `subjects` WHERE `itemValue` ='Mathematics' and `examBoardType`= @examBoardOtherId);
			
            IF EXISTS ((SELECT * FROM enquiry_student_school_subject WHERE enquiryStudentSubject='MATHEMATICS' LIMIT 1)) THEN
            
				INSERT INTO `enquiry_student_examboard_subject` (`subjectId`, `enquiryStudentDetailId`, `lastUpdatedBy`, `lastUpdate`) 
				SELECT @mathematicsId, enquiryStudentDetailId , '1', now()
				FROM enquiry_student_school_subject where enquiryStudentSubject='MATHEMATICS';
				
				SET SQL_SAFE_UPDATES=0;

				UPDATE `enq_student_details` SET `examBoardId` = @examBoardOtherId WHERE `id` IN (SELECT DISTINCT(enquiryStudentDetailId) 
				FROM enquiry_student_school_subject WHERE enquiryStudentSubject='MATHEMATICS');

				SET SQL_SAFE_UPDATES=1;
            
            END IF;

		END IF;
		
		IF EXISTS ((SELECT * FROM `subjects` WHERE `itemValue` ='Physical Science' and `examBoardType`= @examBoardOtherId)) THEN
			SET @physicalScienceId = (SELECT id FROM `subjects` WHERE `itemValue` ='Physical Science' and `examBoardType`= @examBoardOtherId);
            
            IF EXISTS ((SELECT * FROM enquiry_student_school_subject WHERE enquiryStudentSubject='PHYSICAL_SCIENCE' LIMIT 1)) THEN
            
				INSERT INTO `enquiry_student_examboard_subject` 
				(`subjectId`, `enquiryStudentDetailId`, `lastUpdatedBy`, `lastUpdate`) 
				SELECT @physicalScienceId, enquiryStudentDetailId , '1', now()
				FROM enquiry_student_school_subject where enquiryStudentSubject='PHYSICAL_SCIENCE';
				
				SET SQL_SAFE_UPDATES=0;

				UPDATE `enq_student_details` SET `examBoardId` = @examBoardOtherId WHERE `id` IN (SELECT DISTINCT(enquiryStudentDetailId) 
				FROM enquiry_student_school_subject WHERE enquiryStudentSubject='PHYSICAL_SCIENCE');

				SET SQL_SAFE_UPDATES=1;
                
            END IF;
            
		END IF;

	END IF; 

END $$
CALL V20201209132257__Update_CopyDataOfEnquirySubject () $$
DROP PROCEDURE IF EXISTS V20201209132257__Update_CopyDataOfEnquirySubject $$
DELIMITER ;