DELIMITER $$
DROP PROCEDURE IF EXISTS V20201221123546__Insert_Placement_followUpStatus_Main $$
CREATE PROCEDURE V20201221123546__Insert_Placement_followUpStatus_Main()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PLACEMENT_FOLLOWUPSTATUS_CSM')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'placement_followupstatus_csm','PLACEMENT_FOLLOWUPSTATUS_CSM','tools & services','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 

IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'placement_followupstatus_csm');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'PLACEMENT_FOLLOWUPSTATUS_CSM')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'PLACEMENT_FOLLOWUPSTATUS_CSM', 'Placement Follow Up Status', 'Placement Follow Up Status','Plasingsopvolgstatus','Trạng thái Theo dõi Vị trí',now(),1);
END IF;


END $$
CALL V20201221123546__Insert_Placement_followUpStatus_Main() $$
DROP PROCEDURE IF EXISTS V20201221123546__Insert_Placement_followUpStatus_Main $$
DELIMITER ;