DELIMITER $$
DROP PROCEDURE IF EXISTS V20201224152948__Alter_ElectionVoterPoolAddCol $$
CREATE PROCEDURE V20201224152948__Alter_ElectionVoterPoolAddCol()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='election_voter_pool' AND column_name in ('admissionId','batchId','seatTypeId','programId'))) THEN 
ALTER TABLE `election_voter_pool` 
ADD COLUMN `admissionId` BIGINT NULL DEFAULT NULL AFTER `lastUpdate`,
ADD COLUMN `batchId` BIGINT NULL DEFAULT NULL AFTER `admissionId`,
ADD COLUMN `programId` BIGINT NULL DEFAULT NULL AFTER `batchId`,
ADD COLUMN `seatTypeId` BIGINT NULL DEFAULT NULL AFTER `programId`,
ADD INDEX `fk_ev_pool_admisionId_idx` (`admissionId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_programId_idx` (`programId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_seat_type_id_idx` (`seatTypeId` ASC) VISIBLE,
ADD INDEX `fk_ev_pool_programbatchId_idx` (`batchId` ASC) VISIBLE;

ALTER TABLE `election_voter_pool` 
ADD CONSTRAINT `fk_ev_pool_admissionId`
  FOREIGN KEY (`admissionId`)
  REFERENCES `admission` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_ev_pool_programId`
  FOREIGN KEY (`programId`)
  REFERENCES `programs` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_ev_pool_programbatchId`
  FOREIGN KEY (`batchId`)
  REFERENCES `batches` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `fk_ev_pool_seat_type_id`
  FOREIGN KEY (`seatTypeId`)
  REFERENCES `prog_batch_seat_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


END IF; 

END $$
CALL V20201224152948__Alter_ElectionVoterPoolAddCol() $$
DROP PROCEDURE IF EXISTS V20201224152948__Alter_ElectionVoterPoolAddCol $$
DELIMITER ;