DELIMITER $$

DROP PROCEDURE IF EXISTS V20210108182150__InsertDFRForPerson $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210108182150__InsertDFRForPerson()

BEGIN
  
  -- Insert new record in form_field_info table, if it doesn't already exist
  
IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and  formFieldName ='identityExpiryDate')) THEN
	-- Insert Query 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
	VALUES ('personalinformationform','identityExpiryDate','identityExpiryDateItemId','datefield',0,0,NULL,1,now(),'Identity Expiry Date','1','Personal Details Info','Create, Edit, and View','Identity Expiry Date',0);
END IF;  

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and  formFieldName ='currentActivity')) THEN
	-- Insert Query 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
	VALUES ('personalinformationform','currentActivity','currentActivity','nestedJsonCombo',0,0,NULL,1,now(),'Current Activity','1','Personal Details Info','Create, Edit, and View','Current Activity',0);
END IF;
 

END $$

-- Execute the stored procedure
CALL V20210108182150__InsertDFRForPerson() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210108182150__InsertDFRForPerson $$
 
DELIMITER ;