DELIMITER $$

DROP PROCEDURE IF EXISTS V20210120140701__Create_WMSFileInfo $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210120140701__Create_WMSFileInfo()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='wms_file_info' )) THEN
    
    CREATE TABLE `wms_file_info` (
      `id` bigint(20) NOT NULL AUTO_INCREMENT,
      `filePath` varchar(255) NULL DEFAULT NULL,
      `sentDate` timestamp NULL DEFAULT NULL,
      `sentToWMSStatus` bit(1) NULL DEFAULT NULL,
      `typeOfFile` varchar(50) NULL DEFAULT NULL,
       PRIMARY KEY (`id`)
    );
    
  END IF ;

END $$

-- Execute the stored procedure
CALL V20210120140701__Create_WMSFileInfo $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210120140701__Create_WMSFileInfo $$
 
DELIMITER ;