DELIMITER $$
DROP PROCEDURE IF EXISTS V20210120151019__Create_DM_File_Type_Main $$
CREATE PROCEDURE V20210120151019__Create_DM_File_Type_Main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_master_file_type')) THEN 
CREATE TABLE `document_master_file_type` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `documentTypeId` bigint DEFAULT NULL,
  `fileTypeId` bigint DEFAULT NULL,
  `size` int DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_document_master_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_document_master_type_documentStatusId_idx` (`documentTypeId`),
  KEY `fk_document_master_type_fileTypeId` (`fileTypeId`),
  CONSTRAINT `fk_document_master_type_documentStatusId` FOREIGN KEY (`documentTypeId`) REFERENCES `document_types` (`id`),
  CONSTRAINT `fk_document_master_type_fileTypeId` FOREIGN KEY (`fileTypeId`) REFERENCES `file_type` (`id`),
  CONSTRAINT `fk_document_master_type_size_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20210120151019__Create_DM_File_Type_Main () $$ 
DROP PROCEDURE IF EXISTS V20210120151019__Create_DM_File_Type_Main $$ 
DELIMITER ;