DELIMITER $$
DROP PROCEDURE IF EXISTS V20210224144436__Create_ArmsOfServiceTable $$
CREATE PROCEDURE V20210224144436__Create_ArmsOfServiceTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='arms_of_service')) THEN 

	CREATE TABLE `arms_of_service` (
		`id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `itemCode` varchar(255) NOT NULL,
		  `itemValue` varchar(255) NOT NULL,
		  `itemValueInOtherLanguage` varchar(255),
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`),
		 KEY `fk_arms_Of_Service_updateby` (`lastUpdatedBy`),
		  CONSTRAINT `fk_arms_Of_Service_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) 
			  ON DELETE NO ACTION 
			  ON UPDATE NO ACTION
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'arms_of_service')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1,'arms_of_service','ARMS_OF_SERVICE','Admissions','COMMON_MASTER',0,0,1,SYSDATE());
			
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'itemValueInOtherLanguage', 'ITEM_VALUE_IN_OTHER_LANGUAGE', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 1, '1',SYSDATE());

	END IF; 
END $$
CALL V20210224144436__Create_ArmsOfServiceTable () $$ 
DROP PROCEDURE IF EXISTS V20210224144436__Create_ArmsOfServiceTable $$ 
DELIMITER ;