DELIMITER $$
DROP PROCEDURE IF EXISTS V20210224151505__Create_Mustering $$
CREATE PROCEDURE V20210224151505__Create_Mustering()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='mustering')) THEN 
CREATE TABLE `mustering` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`armsOfServiceId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,
		`itemValueInOtherLanguage` varchar(255),
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_mustering_arms_Of_Service_id_idx` (`armsOfServiceId` ASC),
		INDEX `fk_mustering_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_mustering_arms_Of_Service_id_idx`
		    FOREIGN KEY (`armsOfServiceId`)
		    REFERENCES `arms_of_service` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_mustering_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'mustering')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'mustering','MUSTERING','Admissions','COMMON_MASTER',1,0,1,SYSDATE());
		
		SET FOREIGN_KEY_CHECKS=0;
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='mustering');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='arms_of_service';
		SET SQL_SAFE_UPDATES = 1;
		SET FOREIGN_KEY_CHECKS=1;
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
		
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());

		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'itemValueInOtherLanguage', 'ITEM_VALUE_IN_OTHER_LANGUAGE', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 1, '1',SYSDATE());

	END IF; 


END $$
CALL V20210224151505__Create_Mustering () $$ 
DROP PROCEDURE IF EXISTS V20210224151505__Create_Mustering $$ 
DELIMITER ;