DELIMITER $$
DROP PROCEDURE IF EXISTS V20210310181734__Insert_reportTemplate $$
CREATE PROCEDURE V20210310181734__Insert_reportTemplate()
BEGIN

IF EXISTS (SELECT * FROM report_type WHERE typeName = 'Student Event Assessment Report') THEN
set @ReportTypeId = (select max(id) from report_type where typeName ='Student Event Assessment Report');
IF NOT EXISTS (SELECT * FROM `report_template` where `reportTypeId`=@ReportTypeId and `templateCode`='COURSE_AND_EVENT_REPORT' and `templateName`='Course And Event Report') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@ReportTypeId, 'COURSE_AND_EVENT_REPORT', 'Course And Event Report', 'COURSE_AND_EVENT_REPORT.png', 'CommonReport_Excel_withoutHeader.jasper', 'All', '0', 'Header_Excel_Blank.jasper', 'Footer_Excel_Blank.jasper', '0', '0', 'COURSE_AND_EVENT_REPORT.jasper', 'AcademiaLogo.jpg');
END IF; 

IF EXISTS (SELECT * FROM report_template WHERE templateCode='COURSE_AND_EVENT_REPORT' and templateName='Course And Event Report') THEN
set @reportTemplateId = (select max(id) from report_template where templateCode='COURSE_AND_EVENT_REPORT' and templateName='Course And Event Report');

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PROGRAM_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PROGRAM_NAME', 'Program Name', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_BATCH_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_BATCH_NAME', 'Batch Name', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_COURSE_CODE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_COURSE_CODE', 'Course Code', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_COURSE_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_COURSE_NAME', 'Course Name', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_COURSE_SECTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_COURSE_SECTION', 'Course Section', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_LECTURER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_LECTURER', 'Lecturer Name & Surname', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_ASSESSMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_ASSESSMENT', 'Assessment', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_SRNO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_SRNO', 'S.NO.', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NAME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NAME', 'SURNAME & NAME', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_STUDENT_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_STUDENT_NUMBER', 'STUDENT NUMBER', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_IDENTITY_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_IDENTITY_NUMBER', 'IDENTITY NUMBER', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_ACCESSOR_MARKS_AWARDED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_ACCESSOR_MARKS_AWARDED', 'Assessor Mark Awarded', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_MODERATOR_MARK_AWRDED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_MODERATOR_MARK_AWRDED', 'Moderator Mark Awarded', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_TYPE_A')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_TYPE_A', 'Type "A" if absent', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_WROTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_WROTE', 'Wrote', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PASSED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PASSED', 'Passed', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_FAIL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_FAIL', 'Failed', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PASS_PERCENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PASS_PERCENT', 'Pass %', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_AVG_PERCENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_AVG_PERCENT', 'Avg %', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NO_OF_ENROLLED_SUBJECT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NO_OF_ENROLLED_SUBJECT', 'No. Enrolled for Subject', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NO_OF_WROTE_SUBJECT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NO_OF_WROTE_SUBJECT', 'No. Wrote the Subject', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_RETENTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_RETENTION', 'Retention', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_ABSENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_ABSENT', 'Absent', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_WEIGHTING')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_WEIGHTING', 'Weighting', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_LECTURER_SIGNAGURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_LECTURER_SIGNAGURE', 'Lecturer Signature', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_MODERATOR_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_MODERATOR_SIGNATURE', 'Moderator Signature', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_EDUCATION_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_EDUCATION_SIGNATURE', 'Education Specialist Signature', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PROGRAM_HEAD_SIGNATURE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PROGRAM_HEAD_SIGNATURE', 'Programme Head Signature', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_MODERATOR_AVG')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_MODERATOR_AVG', 'Moderator Average', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_EVIDENCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_EVIDENCE', 'EVIDENCE OF REVIEW: DIAGNOSTIC AND STATISTICAL ANALYSIS PER ASSESSMENT TASK', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_DESCRIPTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_DESCRIPTION', 'Description', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_ASSESSMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_ASSESSMENT', 'Assessment', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_CATEGORY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_CATEGORY', 'Category', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NUMBER')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NUMBER', 'No.', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_TOTAL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_TOTAL', 'Total', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_CAMPUS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_CAMPUS', 'Campus', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NO_OF_STUDENT_ENROLLED')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NO_OF_STUDENT_ENROLLED', 'No. of Students Enrolled', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_NO_OF_STUDENT_WROTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_NO_OF_STUDENT_WROTE', 'No. of Students Wrote', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PASS_RATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PASS_RATE', 'Pass Rate', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_CLASS_AVG')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_CLASS_AVG', 'Class Average', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_RETENTATION_RATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_RETENTATION_RATE', 'Retention Rate', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_REFLECTION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_REFLECTION', 'Reflection', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_COMMON_ERROR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_COMMON_ERROR', 'Common errors', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_REMEDIAL_INTERVENTIONS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_REMEDIAL_INTERVENTIONS', 'Remedial interventions', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_CONCERNS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_CONCERNS', 'Concerns', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_REVIEW_OF_INSTRUMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_REVIEW_OF_INSTRUMENT', 'Review of Instrument - Improvement for future use', '1');
END IF; 

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_PERCENTAGE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_PERCENTAGE', '%', '1');
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTemplateId AND keyValue='TRANS_ICASS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTemplateId, 'TRANS_ICASS', 'ICASS', '1');
END IF;

END IF;

END IF;

END $$
CALL V20210310181734__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20210310181734__Insert_reportTemplate $$
DELIMITER ;