DELIMITER $$
DROP PROCEDURE IF EXISTS V20210315152745__Create_MarkEventAttendance $$
CREATE PROCEDURE V20210315152745__Create_MarkEventAttendance()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='mark_event_attendance' )) THEN 
CREATE TABLE `mark_event_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
 
  `resourceBookingUserId` bigint(20) DEFAULT NULL,
  `departmentId` bigint(20) DEFAULT NULL,
  `userId` bigint(20) DEFAULT NULL,
 `dateOfAttendance` date DEFAULT NULL,
  `attendanceStatus` varchar(25) DEFAULT NULL,
 `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
 
  KEY `fk_event_attendance_resourceBookingUserId` (`resourceBookingUserId`),
  KEY `fk_event_attendance_departmentId` (`departmentId`),
  KEY `fk_event_attendance_userId` (`userId`),
  KEY `fk_hostel_attendance_lastUpdatedBy` (`lastUpdatedBy`),
  
  CONSTRAINT `fk_event_attendance_resourceBookingId` FOREIGN KEY (`resourceBookingUserId`) REFERENCES `resource_booking_users` (`id`),
  CONSTRAINT `fk_event_attendance_departmentId` FOREIGN KEY (`departmentId`) REFERENCES `department` (`id`),
  CONSTRAINT `fk_event_attendance_userId` FOREIGN KEY (`userId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `fk_event_attendance_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
END IF; 

END $$
CALL V20210315152745__Create_MarkEventAttendance () $$ 
DROP PROCEDURE IF EXISTS V20210315152745__Create_MarkEventAttendance $$ 
DELIMITER ;