DELIMITER $$
DROP PROCEDURE IF EXISTS V20210325190038__Insert_STD_IDCard_ISBM $$
CREATE PROCEDURE V20210325190038__Insert_STD_IDCard_ISBM()
BEGIN


IF EXISTS (select max(id) from report_type where typeName='Student ID Card') THEN
set  @stdId = (select max(id) from report_type where typeName='Student ID Card');


INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@stdId, 'STUDENT_ID_CARD_ISBM', 'Student ID Card - ISBM', 'STUDENT_ID_CARD_ISBM.png', 'CommonReport_IdCard_UGI_Vertical.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'STUDENT_ID_CARD_ISBM.jasper', 'AcademiaLogo.png');

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'STUDENT_ID_CARD_ISBM')) THEN 
set @transID = (select max(id) from `report_template` WHERE templateCode = 'STUDENT_ID_CARD_ISBM');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_NAME', 'Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_CLASS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_CLASS', 'Class:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_STUDENT_ID', 'Student ID:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_DATE_OF_BIRTH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_DATE_OF_BIRTH', 'Date of Birth:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_FATHERS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_FATHERS_NAME', 'Fathers Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_EMERGENCY_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_EMERGENCY_NO', 'Emergency No:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_LOCATION_MOB')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_LOCATION_MOB', 'Mob', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @transID and keyValue='TRANS_MOBILE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@transID, 'TRANS_MOBILE_NO', 'Mobile No:', '1', now());
END IF;

END IF;
END IF;
END $$
CALL V20210325190038__Insert_STD_IDCard_ISBM() $$
DROP PROCEDURE IF EXISTS V20210325190038__Insert_STD_IDCard_ISBM $$
DELIMITER ;

