DELIMITER $$
DROP PROCEDURE IF EXISTS V20210608114501__Insert_GNA_HallTicket $$
CREATE PROCEDURE V20210608114501__Insert_GNA_HallTicket()
BEGIN
 
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GNA_HALL_TICKET' )) THEN 
set @gna = (select id from report_type WHERE typeName = 'Hall Ticket');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@gna, 'GNA_HALL_TICKET', 'GNA Hall Ticket', 'GNA_HALL_TICKET.png', 'CommonReport_GNA.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'GNA_HALL_TICKET.jasper', 'AcademiaLogo.png'); 
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GNA_HALL_TICKET')) THEN 
set @hall = (select max(id) from `report_template` WHERE templateCode = 'GNA_HALL_TICKET');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_END_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_END_SEMESTER', 'END SEMESTER EXAM', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_EXAM_MONTH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_EXAM_MONTH', 'Exam Month:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_EXAM_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_EXAM_YEAR', 'Exam Year:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_STD_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_STD_NAME', 'Student Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_FATHER_NAME', 'Father Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_REG_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_REG_NUM', 'Registration No.:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_SEMESTER', 'Semester:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_PROGRAM', 'Program:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_DETAIL_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_DETAIL_COURSE', 'Detail of Course Code & Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_EXAM_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_EXAM_DATE', 'Exam Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_START_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_START_TIME', 'Start Time', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_END_TIME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_END_TIME', 'End Time', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_SUBJECT_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_SUBJECT_CODE', 'Subject Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_SUBJECT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_SUBJECT_NAME', 'Subject Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_STD_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_STD_SIGNATURE', 'Signature of Student', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @hall and keyValue='TRANS_DY_REG')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@hall, 'TRANS_DY_REG', 'Dy. Registrar', '1', now());
END IF;

END $$
CALL V20210608114501__Insert_GNA_HallTicket() $$
DROP PROCEDURE IF EXISTS V20210608114501__Insert_GNA_HallTicket $$
DELIMITER ;
