DELIMITER $$
DROP PROCEDURE IF EXISTS V20210609165910__Insert_IIITB_GradeRosterReport $$
CREATE PROCEDURE V20210609165910__Insert_IIITB_GradeRosterReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB' )) THEN 
set @roster1 = (select id from report_type WHERE typeName = 'Grade Roster Report');

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES(@roster1 , 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB', 'Grade roster Report - Faculty Wise', 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB.png', 'CommonReport_PageNumber.jasper','All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB.jasper', 'AcademiaLogo.png');

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB')) THEN 
set @grade1 = (select max(id) from `report_template` WHERE templateCode = 'GRADE_ROSTER_REPORT_TERM_WISE_IIITB');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_TEAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_TEAM', 'Term', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_DATE', 'Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_COURSE', 'Course', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_CLASS_INSTRUCTOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_CLASS_INSTRUCTOR', 'Faculty', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_SR_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_SR_NO', ' Sr.No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_GRADE', 'Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_RESULT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_RESULT', 'Result', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_GRADE_ROSTER_REPORT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_GRADE_ROSTER_REPORT', 'Grade Roster Report', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @grade1 and keyValue='TRANS_INSUTRUCTOR_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@grade1, 'TRANS_INSUTRUCTOR_SIGNATURE', 'Faculty Signature', '1', now());
END IF;

END IF;
END $$
CALL V20210609165910__Insert_IIITB_GradeRosterReport() $$
DROP PROCEDURE IF EXISTS V20210609165910__Insert_IIITB_GradeRosterReport $$
DELIMITER ;
