DELIMITER $$
DROP PROCEDURE IF EXISTS V20210702142325__CreateNSFASProvisionalFund $$
CREATE PROCEDURE V20210702142325__CreateNSFASProvisionalFund()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nsfas_person_provisional_fund')) THEN 
CREATE TABLE `nsfas_person_provisional_fund` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `national_id` varchar(100) NOT NULL,
  `application_ref_no` varchar(150) DEFAULT NULL,
  `is_applicant_indicator` BIT(1) DEFAULT NULL,
  `is_returning_student_indicator` BIT(1) DEFAULT NULL,
  `funding_year` varchar(50) DEFAULT NULL,
  `cycle` varchar(50) DEFAULT NULL,
  `is_funded` BIT(1) DEFAULT NULL,
  `funder` varchar(50) DEFAULT NULL,
  `institution_type` varchar(50) DEFAULT NULL,
  `institution_id` INT DEFAULT NULL,
  `identification_type` varchar(50) DEFAULT NULL,
  `applicant_person_id` bigint DEFAULT NULL,
  `student_person_id` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_nsfas_provisional_fund_id_idx` (`lastUpdatedBy`),
  KEY `fk_nsfas_provisional_fund_applicantperson_id_idx` (`applicant_person_id`),
  KEY `fk_nsfas_provisional_fund_studentperson_id_idx` (`student_person_id`),
  CONSTRAINT `fk_nsfas_provisional_fund_applicantperson_id` FOREIGN KEY (`applicant_person_id`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `fk_nsfas_provisional_fund_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_nsfas_provisional_fund_studentperson_id` FOREIGN KEY (`student_person_id`) REFERENCES `persons` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210702142325__CreateNSFASProvisionalFund () $$ 
DROP PROCEDURE IF EXISTS V20210702142325__CreateNSFASProvisionalFund $$ 
DELIMITER ;