DELIMITER $$
DROP PROCEDURE IF EXISTS V20210909120012__Create_sap_student_detail_view $$
CREATE PROCEDURE V20210909120012__Create_sap_student_detail_view()
BEGIN

DROP VIEW IF EXISTS sap_student_detail_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='sap_student_detail_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `sap_student_detail_view` AS
    SELECT 
        `usr`.`firstName` AS `First_Name`,
        `usr`.`middleName` AS `Middle_Name`,
        `usr`.`lastName` AS `Last_Name`,
        `usr`.`printName` AS `Print_Name`,
        `gen`.`itemValue` AS `Gender`,
        `per`.`birthDate` AS `Date_Of_Birth`,
        `cntry`.`countryName` AS `Country`,
        `per`.`nationalID` AS `Id_Card_No`,
        `usr`.`code` AS `ID`,
        `usr`.`status` AS `Status`,
        `adr`.`addressText` AS `Address`,
        CONCAT(`per`.`phoneAreaCode`,
                ' ',
                `per`.`phoneNo`) AS `Phone_No`,
        `per`.`mobileNumber` AS `Mobile_No`,
        `per`.`emailId` AS `Email`,
        `per`.`alternateEmailId` AS `Alt_Email`,
        `usr`.`printName` AS `Name_In_Bank`,
        `bd`.`accountNumber` AS `Bank_Acc_No`,
        `at`.`itemValue` AS `Bank_Acc_Type`,
        `bd`.`bankName` AS `Bank_Name`,
        `bd`.`branchName` AS `Bank_Branch_Name`,
        `bd`.`IFSCode` AS `Bank_IFSC_Code`,
        `stp`.`seatName` AS `Seat_Type`,
        GROUP_CONCAT(DISTINCT `fpd`.`payerType`
            SEPARATOR ',') AS `FeePayerType`,
        GROUP_CONCAT(DISTINCT `fpd`.`firstName`
            SEPARATOR ',') AS `NameOfContactPerson`,
        GROUP_CONCAT(DISTINCT `fpd`.`contactPerson`
            SEPARATOR ',') AS `NameOfCorporateContactPerson`,
        GROUP_CONCAT(DISTINCT `fpd`.`companyName`
            SEPARATOR ',') AS `NameOfCompany`,
        GROUP_CONCAT(DISTINCT `fpadd`.`addressText`
            SEPARATOR ',') AS `FeePayerAddress`,
        GROUP_CONCAT(DISTINCT `fpd`.`companyAddress`
            SEPARATOR ',') AS `CompanyAddress`,
        GROUP_CONCAT(DISTINCT `fpd`.`corporateId`
            SEPARATOR ',') AS `CorporateId`,
        `pgrp`.`groupName` AS `Program_Group`,
        `per`.`lastUpdate` AS `Last_Update`,
        `prog`.`programCode` AS `programcode`,
        `ir`.`itemCode` AS `intake_year`,
        `per`.`printNameOtherLanguage` AS `printnameotherlanguage`,
        `bd`.`beneficiaryName` AS `beneficiaryName`,
        `bd`.`beneficiaryNameOtherLanguage` AS `beneficiaryNameOtherLanguage`
    FROM
    
        ((((((((((((((((((`students` `std`
        JOIN `users` `usr` ON ((`std`.`userId` = `usr`.`id`)))
        JOIN `persons` `per` ON ((`std`.`personId` = `per`.`id`)))
        LEFT JOIN `person_addresses` `peradd` ON ((`per`.`id` = `peradd`.`personId`)))
        LEFT JOIN `address` `adr` ON ((`adr`.`id` = `peradd`.`addressId`)))
        JOIN `gender` `gen` ON ((`per`.`genderId` = `gen`.`id`)))
        LEFT JOIN `country` `cntry` ON ((`per`.`countryId` = `cntry`.`id`)))
        LEFT JOIN `bank_details` `bd` ON ((`per`.`bankDetailId` = `bd`.`id`)))
        LEFT JOIN `account_type` `at` ON ((`bd`.`accountTypeId` = `at`.`id`)))
        JOIN `admission` `adm` ON ((`std`.`userId` = `adm`.`studentId`)))
        JOIN `program_batch_students` `pbs` ON ((`pbs`.`admissionId` = `adm`.`id`)))
        JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `pbs`.`progBatchSeatConfigId`)))
        JOIN `seat_types` `stp` ON ((`stp`.`id` = `pbsc`.`seatTypeId`)))
        LEFT JOIN `fee_payer_detail` `fpd` ON ((`per`.`id` = `fpd`.`personId`)))
        JOIN `programs` `prog` ON ((`adm`.`programId` = `prog`.`id`)))
        JOIN `program_group` `pgrp` ON ((`prog`.`programGroupId` = `pgrp`.`id`)))
        LEFT JOIN `address` `fpadd` ON ((`fpd`.`addressId` = `fpadd`.`id`)))
        LEFT JOIN `batches` `btc` ON ((`btc`.`id` = `pbsc`.`programBatchId`)))
        LEFT JOIN `intake_year` `ir` ON ((`ir`.`id` = `btc`.`intakeYearId`)))
    GROUP BY `usr`.`id`;

END IF; 

END $$
CALL V20210909120012__Create_sap_student_detail_view () $$ 
DROP PROCEDURE IF EXISTS V20210909120012__Create_sap_student_detail_view $$ 
DELIMITER ;