DELIMITER $$
DROP PROCEDURE IF EXISTS V20210910171915__Create_su_module_details_view $$
CREATE PROCEDURE V20210910171915__Create_su_module_details_view()
BEGIN

DROP VIEW IF EXISTS su_module_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='su_module_details')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `su_module_details` AS
    SELECT Distinct
        `cou`.`courseName` AS `Module Name`,
        `cou`.`courseCode` AS `Module Code`,
        `dept`.`deptName` AS `DepartmentName`,
        `dept`.`shortCode` AS `DepartmentCode`,
        `cou`.`courseCredits` AS `Module Credit`,
        `cou`.`courseCodeToBePrinted` AS `Module Code to be printed`,
        `cou`.`nameToBePrinted` AS `Module Name to be printed`,
        `cou`.`courseNameLanguageOne` AS `Module Name Language 1`,
        `cou`.`courseNameLanguageTwo` AS `Module Name Language 2`,
        `cnl`.`itemValue` AS `Module NQF level`,
        `ccc`.`courseCESMValue` AS `Module CESM code`
    FROM
        (((`courses` `cou`
        LEFT JOIN `courses_departments` `cdept` ON ((`cou`.`id` = `cdept`.`courseId`))
        LEFT JOIN `department` `dept` ON ((`dept`.`id` = `cdept`.`departmentId`)))
        LEFT JOIN `course_nqf_level` `cnl` ON ((`cnl`.`id` = `cou`.`courseNQFLevelId`)))
        LEFT JOIN `course_cesm_code` `ccc` ON ((`ccc`.`id` = `cou`.`courseCESMCodeId`)))
        where cou.parentCourseId is null;

END IF; 

END $$
CALL V20210910171915__Create_su_module_details_view () $$ 
DROP PROCEDURE IF EXISTS V20210910171915__Create_su_module_details_view $$ 
DELIMITER ;