DELIMITER $$
DROP PROCEDURE IF EXISTS V20210921144810__Update_alterDynamicDocumentSeedData $$
CREATE PROCEDURE V20210921144810__Update_alterDynamicDocumentSeedData()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='ADMISSION_INFO' and publishAsParametersDef='student_id=PRM_STUDENT_ID')) THEN 
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\n pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\n psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\n b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\n ay.itemValue AS academic_year ,a.code AS admission_code ,a.studentId as student_id\n FROM admission a\n LEFT JOIN programs p ON a.programId = p.id\n LEFT JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id\n LEFT JOIN batches b   ON b.id = pbsc.programBatchId\n LEFT JOIN intake_year ay ON ay.id = b.intakeYearId\n LEFT JOIN department pd ON pd.id = p.programDepartmentId\n LEFT JOIN department psd ON psd.id = p.subDepartmentId' 
WHERE dataSourceCode='ADMISSION_INFO' and publishAsParametersDef='student_id=PRM_STUDENT_ID';
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20210921144810__Update_alterDynamicDocumentSeedData () $$
DROP PROCEDURE IF EXISTS V20210921144810__Update_alterDynamicDocumentSeedData $$
DELIMITER ;
