DELIMITER $$
DROP PROCEDURE IF EXISTS V20211117190219__Insert_NECBStudentIdCard $$
CREATE PROCEDURE V20211117190219__Insert_NECBStudentIdCard()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'NECB_STUDENT_ID_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '7', 'NECB_STUDENT_ID_CARD', 'NECB Student Id Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'NECB_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');

END IF; 

set @NECB_STUDENT_ID_CARD = (select max(id) from report_template where templateCode ='NECB_STUDENT_ID_CARD');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='STUDENT_ID_CARD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'STUDENT_ID_CARD', 'STUDENT ID CARD', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='START_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'START_DATE', 'Start Date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='END_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'END_DATE', 'End Date', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='RULES_REGULATIONS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'RULES_REGULATIONS', 'Rules & Regulations', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='RULES_TEXT_LINE_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'RULES_TEXT_LINE_ONE', 'rules_text_line_one', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='RULES_TEXT_LINE_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'RULES_TEXT_LINE_TWO', 'rules_text_line_two', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='RULES_TEXT_LINE_THREE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'RULES_TEXT_LINE_THREE', 'rules_text_line_three', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='RULES_TEXT_LINE_FOUR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'RULES_TEXT_LINE_FOUR', 'rules_text_line_four', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='MOBILE_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'MOBILE_NO', 'tell_number_and_cell', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='ADDRESS_TEXT_ONE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'ADDRESS_TEXT_ONE', 'address_line_one', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='ADDRESS_TEXT_TWO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'ADDRESS_TEXT_TWO', 'address_line_two', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='EMAIL_TEXT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'EMAIL_TEXT', 'email_and_website', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @NECB_STUDENT_ID_CARD and keyValue='VALID_TILL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@NECB_STUDENT_ID_CARD, 'VALID_TILL', 'Valid Untill' ,'1', NOW());
END IF;

END $$
CALL V20211117190219__Insert_NECBStudentIdCard() $$
DROP PROCEDURE IF EXISTS V20211117190219__Insert_NECBStudentIdCard $$
DELIMITER ;