DELIMITER $$
DROP PROCEDURE IF EXISTS V20211222155339__Create_residence_selection_choices_view $$
CREATE PROCEDURE V20211222155339__Create_residence_selection_choices_view()
BEGIN
DROP VIEW IF EXISTS residence_selection_choices;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='residence_selection_choices')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `residence_selection_choices` AS
    SELECT DISTINCT
        `appl`.`code` AS `APP ID`,
        `ap`.`externalSysRefOne` AS `SU Number`,
        `ap`.`lastName` AS `Lastname`,
        `ap`.`firstName` AS `First Name`,
        `ap`.`birthDate` AS `Date of Birth`,
        `appl`.`submissionDate` AS `Date Application Submitted`,
        `edu`.`Gr_11_Average` AS `Gr11 Aggregate`,
        `edu`.`Gr_12_Average` AS `Gr12 Aggregate`,
        `t46`.`itemValue` AS `Population Group`,
        GROUP_CONCAT(DISTINCT `ddown1`.`value`
            SEPARATOR ',') AS `Disabilities`,
        (CASE
            WHEN (`ap`.`wheel_chair_required` = 0) THEN 'No'
            ELSE 'Yes'
        END) AS `Wheelchair`,
        `gen`.`itemValue` AS `Gender`,
        (CASE
            WHEN (`ahr`.`whetherHostelApplicable` = 0) THEN 'No'
            ELSE 'Yes'
        END) AS `Residence Selected`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 2)
                    AND (`ahd`.`sequence` = 1)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-First Preference Stellenbosch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 2)
                    AND (`ahd`.`sequence` = 2)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Second Preference Stellenbosch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 2)
                    AND (`ahd`.`sequence` = 3)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Third Preference Stellenbosch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 9)
                    AND (`ahd`.`sequence` = 1)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-First Preference Lyndoch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 9)
                    AND (`ahd`.`sequence` = 2)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Second Preference Lyndoch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 9)
                    AND (`ahd`.`sequence` = 3)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Third Preference Lyndoch`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 3)
                    AND (`ahd`.`sequence` = 1)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-First Preference Tygerberg`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 3)
                    AND (`ahd`.`sequence` = 2)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Second Preference Tygerberg`,
        MAX((CASE
            WHEN
                ((`ahd`.`academyLocationId` = 3)
                    AND (`ahd`.`sequence` = 3)
                    AND (`ahr`.`whetherDeleted` = 0))
            THEN
                `r`.`resourceName`
        END)) AS `Residence Choice-Third Preference Tygerberg`,
        MAX((CASE
            WHEN (`apro`.`priority` = 1) THEN `al1`.`academyName`
        END)) AS `Faculty-Campus 1`,
        MAX((CASE
            WHEN (`apro`.`priority` = 1) THEN `al1`.`locationName`
        END)) AS `Location_Name_1`,
        MAX((CASE
            WHEN (`apro`.`priority` = 1) THEN `prog`.`programName`
        END)) AS `Program 1 Name`,
        MAX((CASE
            WHEN (`apro`.`priority` = 1) THEN `apro`.`currentStatus`
        END)) AS `Program 1 Offer Status`,
        MAX((CASE
            WHEN (`apro`.`priority` = 1) THEN `st`.`seatName`
        END)) AS `Program 1 Seat type`,
        MAX((CASE
            WHEN (`apro`.`priority` = 2) THEN `al2`.`academyName`
        END)) AS `Faculty-Campus 2`,
        MAX((CASE
            WHEN (`apro`.`priority` = 2) THEN `al2`.`locationName`
        END)) AS `Location_Name_2`,
        MAX((CASE
            WHEN (`apro`.`priority` = 2) THEN `prog`.`programName`
        END)) AS `Program 2 Name`,
        MAX((CASE
            WHEN (`apro`.`priority` = 2) THEN `apro`.`currentStatus`
        END)) AS `Program 2 Offer Status`,
        MAX((CASE
            WHEN (`apro`.`priority` = 2) THEN `st`.`seatName`
        END)) AS `Program 2 Seat type`,
        MAX((CASE
            WHEN (`apro`.`priority` = 3) THEN `al3`.`academyName`
        END)) AS `Faculty-Campus 3`,
        MAX((CASE
            WHEN (`apro`.`priority` = 3) THEN `al3`.`locationName`
        END)) AS `Location_Name_3`,
        MAX((CASE
            WHEN (`apro`.`priority` = 3) THEN `prog`.`programName`
        END)) AS `Program 3 Name`,
        MAX((CASE
            WHEN (`apro`.`priority` = 3) THEN `apro`.`currentStatus`
        END)) AS `Program 3 Offer Status`,
        MAX((CASE
            WHEN (`apro`.`priority` = 3) THEN `st`.`seatName`
        END)) AS `Program 3 Seat type`,
        `edu`.`classification` AS `School Classification`,
        `edu`.`quintile` AS `School Quintile`,
        MAX((CASE
            WHEN
                ((`edu`.`classification` = 0)
                    OR (`edu`.`classification` >= 3.5))
            THEN
                0
            WHEN
                ((`edu`.`classification` > 0)
                    AND (`edu`.`classification` < 2.5))
            THEN
                4
            WHEN
                ((`edu`.`classification` >= 2.5)
                    AND (`edu`.`classification` < 3.5))
            THEN
                2
            WHEN
                ((`edu`.`quintile` = 0)
                    OR (`edu`.`quintile` >= 5))
            THEN
                0
            WHEN
                ((`edu`.`quintile` > 0)
                    AND (`edu`.`quintile` <= 3))
            THEN
                4
            WHEN (`edu`.`quintile` = 4) THEN 2
            ELSE NULL
        END)) AS `Max Socio School`,
        (CASE
            WHEN
                (((`soc`.`parent_qualification1` = 'D')
                    AND (`soc`.`parent_qualification2` <> 'D'))
                    OR ((`soc`.`parent_qualification2` = 'D')
                    AND (`soc`.`parent_qualification1` <> 'D'))
                    OR ((`soc`.`parent_qualification1` = 'D')
                    AND (`soc`.`parent_qualification2` = 'D')))
            THEN
                0
            WHEN
                (((`soc`.`parent_qualification1` = 'C')
                    AND (`soc`.`parent_qualification2` <> 'D'))
                    OR ((`soc`.`parent_qualification2` = 'C')
                    AND (`soc`.`parent_qualification1` <> 'D'))
                    OR ((`soc`.`parent_qualification1` = 'C')
                    AND (`soc`.`parent_qualification2` = 'C')))
            THEN
                1
            ELSE 2
        END) AS `Socio 1st Generation`,
        (CASE
            WHEN
                ((`soc`.`childAllowance` = 'YES')
                    OR (`soc`.`statePension` = 'YES'))
            THEN
                2
            ELSE 0
        END) AS `Sf1`,
        (CASE
            WHEN (`soc`.`schoolFeesBursary` = 'Yes') THEN 2
            ELSE 0
        END) AS `Sf2`,
        CAST(((CASE
                WHEN
                    ((`soc`.`childAllowance` = 'YES')
                        OR (`soc`.`statePension` = 'YES'))
                THEN
                    2
                ELSE 0
            END) + (CASE
                WHEN (`soc`.`schoolFeesBursary` = 'Yes') THEN 2
                ELSE 0
            END))
            AS CHAR CHARSET UTF8MB4) AS `Socio Financial`,
        ((MAX((CASE
            WHEN
                ((`edu`.`classification` = 0)
                    OR (`edu`.`classification` >= 3.5))
            THEN
                0
            WHEN
                ((`edu`.`classification` > 0)
                    AND (`edu`.`classification` < 2.5))
            THEN
                4
            WHEN
                ((`edu`.`classification` >= 2.5)
                    AND (`edu`.`classification` < 3.5))
            THEN
                2
            WHEN
                ((`edu`.`quintile` = 0)
                    OR (`edu`.`quintile` >= 5))
            THEN
                0
            WHEN
                ((`edu`.`quintile` > 0)
                    AND (`edu`.`quintile` <= 3))
            THEN
                4
            WHEN (`edu`.`quintile` = 4) THEN 2
            ELSE NULL
        END)) + (CASE
            WHEN
                (((`soc`.`parent_qualification1` = 'D')
                    AND (`soc`.`parent_qualification2` <> 'D'))
                    OR ((`soc`.`parent_qualification2` = 'D')
                    AND (`soc`.`parent_qualification1` <> 'D'))
                    OR ((`soc`.`parent_qualification1` = 'D')
                    AND (`soc`.`parent_qualification2` = 'D')))
            THEN
                0
            WHEN
                (((`soc`.`parent_qualification1` = 'C')
                    AND (`soc`.`parent_qualification2` <> 'D'))
                    OR ((`soc`.`parent_qualification2` = 'C')
                    AND (`soc`.`parent_qualification1` <> 'D'))
                    OR ((`soc`.`parent_qualification1` = 'C')
                    AND (`soc`.`parent_qualification2` = 'C')))
            THEN
                1
            ELSE 2
        END)) + CAST(((CASE
                WHEN
                    ((`soc`.`childAllowance` = 'YES')
                        OR (`soc`.`statePension` = 'YES'))
                THEN
                    2
                ELSE 0
            END) + (CASE
                WHEN (`soc`.`schoolFeesBursary` = 'Yes') THEN 2
                ELSE 0
            END))
            AS CHAR CHARSET UTF8MB4)) AS `Socio Total`,
        `ci`.`subCategoryName` AS `Select your PSO if not in residence`
    FROM
        ((((((((((((((((((((((((((((`application` `appl`
        JOIN `applicant_person` `ap` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_person` `ap1` ON ((`appl`.`applicantPersonId` = `ap1`.`id`)))
        LEFT JOIN `applicant_person_disability` `apd` ON ((`apd`.`applicantPersonId` = `ap1`.`id`)))
        JOIN `application_program` `apro` ON ((`apro`.`applicationId` = `appl`.`id`)))
        JOIN `programs` `prog` ON ((`apro`.`programId` = `prog`.`id`)))
        JOIN `batches` `btc` ON ((`btc`.`programId` = `prog`.`id`)))
        JOIN `intake_year` `ir` ON ((`btc`.`intakeYearId` = `ir`.`id`)))
        JOIN `academy_location` `al` ON ((`al`.`id` = `prog`.`academyLocationId`)))
        LEFT JOIN `programs` `prog1` ON (((`apro`.`programId` = `prog1`.`id`)
            AND (`apro`.`priority` = 1))))
        LEFT JOIN `academy_location` `al1` ON ((`al1`.`id` = `prog1`.`academyLocationId`)))
        LEFT JOIN `programs` `prog2` ON (((`apro`.`programId` = `prog2`.`id`)
            AND (`apro`.`priority` = 2))))
        LEFT JOIN `academy_location` `al2` ON ((`al2`.`id` = `prog2`.`academyLocationId`)))
        LEFT JOIN `programs` `prog3` ON (((`apro`.`programId` = `prog3`.`id`)
            AND (`apro`.`priority` = 3))))
        LEFT JOIN `academy_location` `al3` ON ((`al3`.`id` = `prog3`.`academyLocationId`)))
        JOIN `gender` `gen` ON ((`gen`.`id` = `ap`.`genderId`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc1` ON ((`pbsc1`.`id` = `apro`.`progBatchSeatConfigId`)))
        LEFT JOIN `seat_types` `st` ON ((`st`.`id` = `pbsc1`.`seatTypeId`)))
        LEFT JOIN `current_activity` `ca` ON ((`ca`.`id` = `ap`.`current_activity_id`)))
        LEFT JOIN `caste_categories` `t46` ON ((`ap`.`casteCategoryId` = `t46`.`id`)))
        LEFT JOIN `drop_down` `ddown1` ON ((`apd`.`haveDisabilityId` = `ddown1`.`id`)))
        LEFT JOIN `applicant_hostel_requirement` `ahr` ON ((`ahr`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_hostel_details` `ahd` ON ((`ahd`.`applicantHostelRequirementId` = `ahr`.`id`)))
        LEFT JOIN `applicant_hostel_requirement_cd` `ahrcd` ON ((`ahr`.`id` = `ahrcd`.`applicantHostelRequirementId`)))
        LEFT JOIN `categories_info` `ci` ON ((`ahrcd`.`cf11` = `ci`.`id`)))
        LEFT JOIN `hostel` `h` ON ((`ahd`.`hostelId` = `h`.`id`)))
        LEFT JOIN `resources` `r` ON ((`h`.`resourceId` = `r`.`id`)))
        LEFT JOIN `analytics_applicant_education_course_wise_view` `edu` ON ((`ap`.`id` = `edu`.`applicantPersonId`)))
        LEFT JOIN `socio_economic_detail_view` `soc` ON ((`soc`.`applicantPersonId` = `ap`.`id`)))
    WHERE
        (`ahr`.`whetherDeleted` = 0)
    GROUP BY `appl`.`id`;

END IF; 

END $$
CALL V20211222155339__Create_residence_selection_choices_view () $$ 
DROP PROCEDURE IF EXISTS V20211222155339__Create_residence_selection_choices_view $$ 
DELIMITER ;