DELIMITER $$
DROP PROCEDURE IF EXISTS V20220127125126__Insert_DataGrid_SponsorshipBillingReport $$
CREATE PROCEDURE V20220127125126__Insert_DataGrid_SponsorshipBillingReport()
BEGIN

IF NOT EXISTS ((select * from data_grid where gridName='Academia.view.sponsorship.SponsorshipBillingGrid' AND portalId=1)) THEN 
INSERT INTO `data_grid`
(
`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`)
VALUES
('Academia.view.sponsorship.SponsorshipBillingGrid',1,
'[
{"id":null,"columnName":"SPONSOR_Id","dataIndex":"sponsorCode","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"SPONSOR_NAME","dataIndex":"sponsorName","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentPrintName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"STUDENT_FIRST_NAME","dataIndex":"studentFirstName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"STUDENT_MIDDLE_NAME","dataIndex":"studentMiddleName","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"STUDENT_LAST_NAME","dataIndex":"studentLastName","columnVisibility":"HIDE","sequence":7,"mandatory":false},
{"id":null,"columnName":"NATIONAL_ID","dataIndex":"nationalID","columnVisibility":"HIDE","sequence":8,"mandatory":false},
{"id":null,"columnName":"ACADEMY","dataIndex":"academyLocationName","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":10,"mandatory":false},
{"id":null,"columnName":"BATCH","dataIndex":"batchName","columnVisibility":"SHOW","sequence":11,"mandatory":false},
{"id":null,"columnName":"SECTION","dataIndex":"sectionsName","columnVisibility":"SHOW","sequence":12,"mandatory":false},
{"id":null,"columnName":"BILL_NO","dataIndex":"billNo","columnVisibility":"SHOW","sequence":13,"mandatory":false},
{"id":null,"columnName":"BILLING_DATE","dataIndex":"billingDate","columnVisibility":"SHOW","sequence":14,"mandatory":false},
{"id":null,"columnName":"STAGE_TYPE","dataIndex":"billStageName","columnVisibility":"SHOW","sequence":15,"mandatory":false},
{"id":null,"columnName":"FEE_HEAD_NAME","dataIndex":"feeHeadName","columnVisibility":"SHOW","sequence":16,"mandatory":false},
{"id":null,"columnName":"FEE_HEAD_TOTAL_AMT_PAYBLE","dataIndex":"feeHeadAmount","columnVisibility":"SHOW","sequence":17,"mandatory":false},
{"id":null,"columnName":"AMOUNT_SPONSORED","dataIndex":"amountSponsored","columnVisibility":"SHOW","sequence":18,"mandatory":false},
{"id":null,"columnName":"AMOUNT_TYPE","dataIndex":"amountType","columnVisibility":"SHOW","sequence":19,"mandatory":false},
{"id":null,"columnName":"SPONSOR_SHIP_PERCENTAGE","dataIndex":"sponsorshipPercentage","columnVisibility":"SHOW","sequence":20,"mandatory":false}
]'

,now(),1);
END IF; 

IF NOT EXISTS ((select * from ui_translation where keyName='SPONSORSHIP_BILLING_REPORT' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','SPONSORSHIP_BILLING_REPORT','Sponsorship Billing Report','Sponsorship Billing Report','Báo cáo thanh toán tài trợ','Borgskap-faktureringverslag',now(),1);
END IF; 


END $$
CALL V20220127125126__Insert_DataGrid_SponsorshipBillingReport() $$
DROP PROCEDURE IF EXISTS V20220127125126__Insert_DataGrid_SponsorshipBillingReport $$
DELIMITER ;