DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_subjectenrolmentdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_subjectenrolmentdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

select distinct
case when char_length(per.nationalId)=13 then per.nationalID else null end as National_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),per.nationalID ,usr1.code) as Person_Alternate_Id,
if ((char_length(per.nationalId)>0 && char_length(per.nationalId)<>13),527,537) as Alternate_Id_Type_Id,
case when aaw.itemCode = 1 and prog.programRegistrationId is not null then course.courseNameLanguageOne
when aaw.itemCode = 3 then course.courseNameLanguageOne else null end as Unit_Standard_Id,
-- case when course.courseNameLanguageOne is not null then course.courseNameLanguageOne else '' end as Unit_Standard_Id,
case when stuce.exitDate is not null then 10 else 3 end as Enrolment_Status_Id,
usr.code as Staff_Number,
modo.itemCode as Enrolment_Type_Id,
case when stuce.exitDate is not null then DATE_FORMAT(stuce.exitDate, '%Y%m%d') else DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') end Enrolment_Status_Date,
DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') as Enrolment_Date,
'' as Filler01,
case when aaw.itemCode = 1 then 2 else aaw.itemCode end as Part_Of_Id,
case when aaw.itemCode = 1 and course.courseNameLanguageOne is not null then prog.programRegistrationId else null end as Qualification_Id,
case when aaw.itemCode='3' then prog.programRegistrationId else null end as Learnership_Id,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
'' as Filler02,
case when aaw.itemCode = 3 then null 
when prog.academicAwardId = 1 and course.courseNameLanguageOne is not null and prog.programRegistrationId is not null then null
else course.courseCode end as Subject_Code,
case when aaw.itemCode <> 1 then null 
when prog.academicAwardId = 1 and course.courseNameLanguageOne is not null and prog.programRegistrationId is not null then null
else prog.programCode end as Programme_Code,
case when stuce.exitDate is not null then 16 else '' end as Enrolment_Status_Reason_Id,
DATE_FORMAT(stuce.enrollmentDate, '%Y%m%d') as Most_Recent_Registration_Date,
case when btc.batchPartTime = 1 then 2 else 1 end as Enrolment_Mode_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
 from
student_course_enrollment stuce
join prog_batch_period_config progbpc on(progbpc.id=stuce.programBatchPeriodConfigId)
join batches btc on(btc.id=progbpc.programBatchId and btc.startDate < NOW() and btc.intakeYearId=intakeYearId)
join programs prog on(prog.id=btc.programId)
join admission adm on (stuce.admissionId=adm.id and adm.activeStatus=1)
join students stu on(stu.userId=adm.studentId)
join users usr1 on(usr1.id=stu.userid)
join mode_of_delivery modo on(btc.modeOfDeliveryId=modo.id)
join persons per on(per.id=stu.personId)
left join academic_award aaw on(aaw.id=prog.academicAwardId)
join course_variants cv on(stuce.courseVarientId=cv.id)
join courses course on(course.id=cv.courseId)
join program_batch_course_param pbcp on(pbcp.courseVarientId=cv.id) and (pbcp.progBatchPeriodConfigId=progbpc.id)
join prog_batch_course_faculty pbcf on(pbcf.progBatchCourseParamId=pbcp.id)
left join users usr on(usr.id=pbcf.facultyId)
left join registration_type rt on(prog.registrationTypeId=rt.id)
left join academy_location al on(al.id=prog.academyLocationId)
left join locations loc on(loc.id=al.locationId)
where FIND_IN_SET( al.id,p_alid) and year(now()) between year(btc.startDate) and year(btc.tillDate) and usr1.status=1
and (case when aaw.itemCode = 3 then prog.programRegistrationId is not null 
when aaw.itemCode=1 then prog.programCode is not null end)
group by usr1.code, course.courseCode;

END//
DELIMITER ;