DELIMITER $$
DROP PROCEDURE IF EXISTS V20220804144759__Create_StudentJointDegreeTable $$
CREATE PROCEDURE V20220804144759__Create_StudentJointDegreeTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_joint_degree')) THEN 
CREATE TABLE `student_joint_degree` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `personId` bigint DEFAULT NULL,
  `collaborationAgreementType` varchar(100) DEFAULT NULL,
  `partnerInstitution1` bigint(20) DEFAULT NULL,
  `partnerInstitutionCountry1` bigint(20) DEFAULT NULL,
  `partnerInstitution2` bigint(20) DEFAULT NULL,
  `partnerInstitutionCountry2` bigint(20) DEFAULT NULL,
  `certificate` varchar(255) DEFAULT NULL,
  `feesExemptedPerYear` bigint(20) DEFAULT NULL,
  `feesExemptedPerYearReason` varchar(255) DEFAULT NULL,
  `ifrReduced` bit(1) DEFAULT NULL,
  `ifrReducedReason` varchar(255) DEFAULT NULL,
  `auditDate` date DEFAULT NULL,
  `auditId` bigint NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_partnerInstitution1` FOREIGN KEY (`partnerInstitution1`) REFERENCES `institute_type` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_partnerInstitutionCountry1` FOREIGN KEY (`partnerInstitutionCountry1`) REFERENCES `country` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_partnerInstitution2` FOREIGN KEY (`partnerInstitution2`) REFERENCES `institute_type` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_partnerInstitutionCountry2` FOREIGN KEY (`partnerInstitutionCountry2`) REFERENCES `country` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
  CONSTRAINT `FK_stdjointdegree_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ;
END IF; 

END $$
CALL V20220804144759__Create_StudentJointDegreeTable () $$ 
DROP PROCEDURE IF EXISTS V20220804144759__Create_StudentJointDegreeTable $$ 
DELIMITER ;