DELIMITER $$
DROP PROCEDURE IF EXISTS V20220808113158__Insert_Exam_Concession_Approval_Letter $$
CREATE PROCEDURE V20220808113158__Insert_Exam_Concession_Approval_Letter()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Exam Concession Form' ); 

IF NOT EXISTS ((select * from report_template where templateCode = 'EXAM_CONCESSION_APPROVAL_LETTER')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'EXAM_CONCESSION_APPROVAL_LETTER', 'Exam Concession Approval Letter', 'EXAM_CONCESSION_APPROVAL_LETTER.png', 'CommonReport_EXAM_CONCESSION_APPROVAL_LETTER.jasper', NULL , 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'EXAM_CONCESSION_APPROVAL_LETTER.jasper', 'AcademiaLogo.png');
END IF; 

set @temp = (select max(id) from report_template where templateCode='EXAM_CONCESSION_APPROVAL_LETTER' and templateName='Exam Concession Approval Letter');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_EXAM_CONCESSION') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_EXAM_CONCESSION', 'Exam Concession Approval Letter', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_STUDENT_DETAILS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_STUDENT_DETAILS', 'Student Details', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_PROGRAM', 'Program', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_BATCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_BATCH', 'Batch', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_SID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_SID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_EMAIL') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_EMAIL', 'Email ID', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_CONTACT_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_CONTACT_NO', 'Contact Number', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_EXAM_CONCESSION_DETAILS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_EXAM_CONCESSION_DETAILS', 'Exam Concession Details', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_START_TIME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_START_TIME', 'Start Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_END_TIME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_END_TIME', 'End Date', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @temp AND keyValue='TRANS_APPROVER_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@temp, 'TRANS_APPROVER_NAME', 'Approver Name', '1', now());
END IF;

END $$
CALL V20220808113158__Insert_Exam_Concession_Approval_Letter() $$
DROP PROCEDURE IF EXISTS V20220808113158__Insert_Exam_Concession_Approval_Letter $$
DELIMITER ;