DELIMITER $$ 
DROP PROCEDURE IF EXISTS V20220808155014__Create_AcademyLocationCampusMain $$
CREATE PROCEDURE V20220808155014__Create_AcademyLocationCampusMain()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academy_location_campus')) THEN 
 CREATE TABLE `academy_location_campus` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20) NOT NULL,
  `campusId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_academy_location_campus_academyLocation_idx` (`academyLocationId` ASC),
  INDEX `fk_academy_location_campus_campus_id_idx` (`campusId` ASC),
  INDEX `fk_academy_location_campus_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_academy_location_campus_academyLocation_id`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_academy_location_campus_campus_id`
    FOREIGN KEY (`campusId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_campus_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20220808155014__Create_AcademyLocationCampusMain () $$ 
DROP PROCEDURE IF EXISTS V20220808155014__Create_AcademyLocationCampusMain $$ 
DELIMITER ;