DELIMITER $$
DROP PROCEDURE IF EXISTS V20220817121542__Insert_costCenterMasterItems $$
CREATE PROCEDURE V20220817121542__Insert_costCenterMasterItems()
BEGIN

ALTER TABLE `standard_master_items` 
CHANGE COLUMN `fieldType` `fieldType` ENUM('Varchar', 'Date', 'Boolean', 'Enum', 'Number', 'Double', 'RadioGroup', 'TextArea', 'multiselectcombofield') NOT NULL ;
	
	
IF EXISTS ((SELECT id FROM standard_master where masterName='COST_CENTRE')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master where masterName='COST_CENTRE');

IF NOT EXISTS ((SELECT id FROM standard_master_items where standardMasterId= @standardMasterId and fieldLabel='DESCRIPTION')) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'description', 'DESCRIPTION', @standardMasterId, 'varchar', '3', 0, 0, 0, 1, '1', SYSDATE());

IF NOT EXISTS ((SELECT id FROM standard_master_items where standardMasterId= @standardMasterId and fieldLabel='ISCONTROLACCOUNT')) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'isControlAccount', 'ISCONTROLACCOUNT', @standardMasterId, 'Boolean', '4', 0, 0, 0, 0, '1', SYSDATE());


IF NOT EXISTS ((SELECT id FROM standard_master_items where standardMasterId= @standardMasterId and fieldLabel='COST_CENTRES')) THEN 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'costCenters', 'CONTROL_ACCOUNT', @standardMasterId, 'multiselectcombofield', '5', 0, 0, 0, 0, '1', SYSDATE());

END IF; 
END IF; 
END IF; 
END IF; 

END $$
CALL V20220817121542__Insert_costCenterMasterItems() $$
DROP PROCEDURE IF EXISTS V20220817121542__Insert_costCenterMasterItems $$
DELIMITER ;