DELIMITER $$
DROP PROCEDURE IF EXISTS V20220915173734__Create_feeStageHeadConfigDayWise $$
CREATE PROCEDURE V20220915173734__Create_feeStageHeadConfigDayWise()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='fee_stage_head_config_day_wise')) THEN 
CREATE TABLE `fee_stage_head_config_day_wise` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `date` DATE NOT NULL,
  `day` VARCHAR(255) NOT NULL,
  `feeHeadAmount` DOUBLE NOT NULL,
  `createdBy` BIGINT NOT NULL,
  `feeStageHeadConfigId` BIGINT NOT NULL,
  `hostelRoomTypeId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
   PRIMARY KEY (`id`),
  INDEX `fk_fee_stage_head_config_day_wise_createdBy_idx` (`createdBy`),
  INDEX `fk_fee_stage_head_config_day_wise_fee_stage_head_config_idx` (`feeStageHeadConfigId`),
  INDEX `fk_fee_stage_head_config_day_wise_hostel_room_type_idx` (`hostelRoomTypeId`),
  INDEX `fk_fee_stage_head_config_day_wise_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fee_stage_head_config_day_wise_to_createdBy_idx`
    FOREIGN KEY (`createdBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_stage_head_config_day_wise_fee_stage_head_config_idx`
    FOREIGN KEY (`feeStageHeadConfigId`)
    REFERENCES `fee_stage_head_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
	CONSTRAINT `fk_fee_stage_head_config_day_wise_hostel_room_type_idx`
    FOREIGN KEY (`hostelRoomTypeId`)
    REFERENCES `hostel_room_type` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_stage_head_config_day_wise_lastUpdatedBy_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20220915173734__Create_feeStageHeadConfigDayWise () $$ 
DROP PROCEDURE IF EXISTS V20220915173734__Create_feeStageHeadConfigDayWise $$ 
DELIMITER ;