DELIMITER $$
DROP PROCEDURE IF EXISTS V20220923132016__Create_learning_target_details_new $$
CREATE PROCEDURE V20220923132016__Create_learning_target_details_new()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target_details_new')) THEN 
CREATE TABLE learning_target_details_new (
  id bigint NOT NULL AUTO_INCREMENT,
  learningTargetNewId bigint NOT NULL,
  admissionId bigint NOT NULL,
  finalResult varchar(255) NOT NULL,
  subjectTarget varchar(255) NOT NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_learning_target_details_new_learningTargetId_idx (learningTargetNewId),
  KEY fk_learning_target_details_new_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_learning_target_details_new_admissionId_idx (admissionId),
  CONSTRAINT fk_learning_target_details_new_admissionId FOREIGN KEY (admissionId) REFERENCES admission (id),
  CONSTRAINT fk_learning_target_details_new_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_learning_target_details_new_learningTargetId FOREIGN KEY (learningTargetNewId) REFERENCES learning_target_new (id)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20220923132016__Create_learning_target_details_new () $$ 
DROP PROCEDURE IF EXISTS V20220923132016__Create_learning_target_details_new $$ 
DELIMITER ;