DELIMITER $$
DROP PROCEDURE IF EXISTS V20221019182945__Create_SSOCredentialsEvent $$
CREATE PROCEDURE V20221019182945__Create_SSOCredentialsEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='UPDATE_STUDENT_CREDENTIALS_DETAILS')) THEN
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'UPDATE_STUDENT_CREDENTIALS_DETAILS');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='UPDATE_STUDENT_CREDENTIALS_DETAILS');
INSERT INTO `system_msg_event`
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'UPDATE_STUDENT_CREDENTIALS_DETAILS', 'Update Student Credentials Details', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Update Student Credentials Details');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Event

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'UPDATE_STUDENT_CREDENTIALS_DETAILS_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT', 'SQL');

-- Create Recipient Type

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_STUDENT_CREDENTIALS_DETAILS_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_STUDENT_CREDENTIALS_DETAILS_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM admission T1 WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT');
INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT
    T1.`id` AS ID,    
    T6.`socialId` AS UPDATE_STUDENT_CREDENTIALS_DETAILS_USERNAME,
    T5.`code` AS UPDATE_STUDENT_CREDENTIALS_DETAILS_APPLICATIONID,
    T3.`code` AS UPDATE_STUDENT_CREDENTIALS_DETAILS_STUDENTID,
    T7.`emailId` AS EMAIL_ID,
	T7.`firstName` AS FIRST_NAME,
    T7.`lastName` AS LAST_NAME
    
FROM
    admission T1
INNER JOIN
students T2 ON T2.userId = T1.studentId
INNER JOIN 
    users T3 ON T3.id = T2.userId
LEFT OUTER JOIN
    application_program T4 ON T4.id = T1.applicationProgramId
LEFT OUTER JOIN
    application T5 ON T5.id = T4.applicationId
LEFT OUTER JOIN
    users_social T6 ON T6.userId = T3.id
INNER JOIN 
	persons T7 ON T7.id = T2.personId    
      
WHERE
    T1.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "socialId",
            "resultKey": "UPDATE_STUDENT_CREDENTIALS_DETAILS_USERNAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "code",
            "resultKey": "UPDATE_STUDENT_CREDENTIALS_DETAILS_APPLICATIONID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "code",
            "resultKey": "UPDATE_STUDENT_CREDENTIALS_DETAILS_STUDENTID",
            "displayCode": "",
            "displayOrder": 2
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='UPDATE_STUDENT_CREDENTIALS_DETAILS_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='UPDATE_STUDENT_CREDENTIALS_DETAILS');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='UPDATE_STUDENT_CREDENTIALS_DETAILS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
VALUES(@msgtemplateconfigId+1,'Update Student Credentials Details',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Update Student Credentials Details',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Student - Update Credential','<html>
<head>
	<title>UPDATE STUDENT DETAILS CREDENTIALS</title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear <strong>$recipientData[&quot;UPDATE_STUDENT_CREDENTIALS_DETAILS_USERNAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please note that student- 
			<strong> $recipientData[&quot;UPDATE_STUDENT_CREDENTIALS_DETAILS_APPLICATIONID&quot;]- 
			$recipientData[&quot;UPDATE_STUDENT_CREDENTIALS_DETAILS_STUDENTID&quot;]</strong> has update the SSO credential -.</p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');



-- End Messaging for UPDATE_STUDENT_CREDENTIALS_DETAILS Event
END IF; 

-- create translation for data provider 
IF NOT EXISTS (((SELECT * FROM picklist_translation WHERE `key` = 'UPDATE_STUDENT_CREDENTIALS_DETAILS'))) THEN 
INSERT INTO `picklist_translation` (`key`, `en`) 
VALUES ('UPDATE_STUDENT_CREDENTIALS_DETAILS', 'Update Student Credentials Details');
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS', 'UPDATE_STUDENT_CREDENTIALS_DETAILS_RECIPIENT', 'Update Student Credentials Details Recipient', 'Update Student Credentials Details Recipient', '', '',now(),1);
END IF; 



IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='UPDATE_STUDENT_CREDENTIALS_DETAILS')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS', 'UPDATE_STUDENT_CREDENTIALS_DETAILS', 'Update Student Credentials Details', 'Update Student Credentials Details', '', '',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='UPDATE_STUDENT_CREDENTIALS_DETAILS_USERNAME')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS', 'UPDATE_STUDENT_CREDENTIALS_DETAILS_USERNAME', 'UserName', 'UserName', '', '',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='UPDATE_STUDENT_CREDENTIALS_DETAILS_APPLICATIONID')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS', 'UPDATE_STUDENT_CREDENTIALS_DETAILS_APPLICATIONID', 'Application ID', 'Application ID', '', '',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='UPDATE_STUDENT_CREDENTIALS_DETAILS_STUDENTID')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS', 'UPDATE_STUDENT_CREDENTIALS_DETAILS_STUDENTID', 'Student ID', 'Student ID', '', '',now(),1);
END IF; 


END $$
CALL V20221019182945__Create_SSOCredentialsEvent () $$ 
DROP PROCEDURE IF EXISTS V20221019182945__Create_SSOCredentialsEvent $$ 
DELIMITER ;