DELIMITER $$
DROP PROCEDURE IF EXISTS V20221123173216__Insert_FeePayer1DynamicDoc $$
CREATE PROCEDURE V20221123173216__Insert_FeePayer1DynamicDoc()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT MIN(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'FEE_PAYER_DETAILS_1', '3',null, '1', '0', 
"Select fd.payerType AS PAYER_TEPY,if(fd.isPrimaryFeePayer = TRUE, 'Yes', 'No') as IS_PRIMERY_PAYER, T1.salutationName as SALUTATION, fd.firstName as FIRST_NAME, 
    fd.middleName as MIDDLE_NAME, fd.lastName AS LAST_NAME, fd.occupation AS OCCUPATION , fd.nationalAlternateId AS NATIONAL_ALTER_ID
    from 
    fee_payer_detail fd 
     left outer join 
    students st on st.personId = fd.personId
	 left outer join
    admission a on a.studentId = st.userId
        LEFT OUTER JOIN 
    salutations T1 ON T1.id = fd.salutationId
        LEFT JOIN
    address T2 ON T2.id = fd.addressId
        LEFT OUTER JOIN
    city T3 ON T3.id = T2.cityId
     LEFT OUTER JOIN
    country_region T4 ON T4.id = T3.countryRegionId
        LEFT OUTER JOIN
    country T5 ON T5.id= T4.countryId", 
    'PRM_ADMISSION_ID', 
	'PAYER_TEPY, IS_PRIMERY_PAYER, SALUTATION, FIRST_NAME, MIDDLE_NAME, LAST_NAME, OCCUPATION, NATIONAL_ALTER_ID',
"where a.id=PRM_ADMISSION_ID and a.activeStatus=TRUE", '1');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('PAYER_TEPY', 'Payer Type',@dydtdatalinitemId+1),
('IS_PRIMERY_PAYER', 'Primery Fee Payer',@dydtdatalinitemId+1),
('SALUTATION', 'salutation',@dydtdatalinitemId+1),
('FIRST_NAME', 'First Name',@dydtdatalinitemId+1),
('MIDDLE_NAME', 'Account Number',@dydtdatalinitemId+1),
('LAST_NAME', 'Last Name',@dydtdatalinitemId+1),
('OCCUPATION', 'occupation',@dydtdatalinitemId+1),
('NATIONAL_ALTER_ID', 'National/Alternate ID',@dydtdatalinitemId+1);
END IF; 

END $$
CALL V20221123173216__Insert_FeePayer1DynamicDoc() $$
DROP PROCEDURE IF EXISTS V20221123173216__Insert_FeePayer1DynamicDoc $$
DELIMITER ;