DELIMITER $$
DROP PROCEDURE IF EXISTS V20221215120133__Create_flag_roles $$
CREATE PROCEDURE V20221215120133__Create_flag_roles()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='flag_roles')) THEN 
	CREATE TABLE `flag_roles` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `roleId` BIGINT NOT NULL,
  `flagId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL ,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) VISIBLE,
  INDEX `fk_flag_role_idx_idx` (`roleId` ASC) VISIBLE,
  INDEX `fk_flag_role_user_idx_idx` (`lastUpdatedBy` ASC) VISIBLE,
  CONSTRAINT `fk_flag_role_idx`
    FOREIGN KEY (`roleId`)
    REFERENCES `roles` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_flag_idx`
    FOREIGN KEY (`flagId`)
    REFERENCES `flag` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_flag_role_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20221215120133__Create_flag_roles () $$ 
DROP PROCEDURE IF EXISTS V20221215120133__Create_flag_roles $$ 
DELIMITER ;