DELIMITER $$
DROP PROCEDURE IF EXISTS V20230110193058__Create_AggregationLoderData $$
CREATE PROCEDURE V20230110193058__Create_AggregationLoderData()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='aggregations_loder_data')) THEN 
CREATE TABLE `aggregations_loder_data` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`userId` BIGINT(20) NOT NULL,
	`aggregationId` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
     CONSTRAINT `aggregationsLoderData_fk_1`
    FOREIGN KEY (`userId`)
    REFERENCES `users` (`id`),
   CONSTRAINT `aggregationsLoderData_fk_2`
    FOREIGN KEY (`aggregationId`)
    REFERENCES `aggregations` (`id`),
	CONSTRAINT `aggregationsLoderData_lastUpdatedBy_FK_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

END $$
CALL V20230110193058__Create_AggregationLoderData () $$ 
DROP PROCEDURE IF EXISTS V20230110193058__Create_AggregationLoderData $$ 
DELIMITER ;