DELIMITER $$
DROP PROCEDURE IF EXISTS V20230208191040__Alter_AddCommitteeTypeInCommittee $$
CREATE PROCEDURE V20230208191040__Alter_AddCommitteeTypeInCommittee()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='committee'  AND  column_name='committeeTypeId')) THEN 
ALTER TABLE `committee` 
ADD COLUMN `committeeTypeId` BIGINT(20) NULL DEFAULT NULL,
ADD CONSTRAINT FOREIGN KEY (`committeeTypeId`) REFERENCES `committee_type`(`id`);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='COMMITTEE_TYPE' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','COMMITTEE_TYPE','Committee Type','Committee Type','Tipe Komite','Loại Ủy ban',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='COMMITTEE_TYPE_IS_ALREADY_MAPPED_WITH_COMMITTEE_NAME' and objectName='ERRORMESSAGE')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('ERRORMESSAGE','COMMITTEE_TYPE_IS_ALREADY_MAPPED_WITH_COMMITTEE_NAME','Committee type is already mapped with Committee name','Committee type is already mapped with Committee name','Komiteetipe is reeds gekarteer met komiteenaam','Loại Ủy ban đã được ánh xạ với tên Ủy ban',now(),1);
END IF;

END $$
CALL V20230208191040__Alter_AddCommitteeTypeInCommittee() $$
DROP PROCEDURE IF EXISTS V20230208191040__Alter_AddCommitteeTypeInCommittee $$
DELIMITER ;