DELIMITER $$
DROP PROCEDURE IF EXISTS V20230214143439__Create_PostgraduateManaStudDataprovider $$
CREATE PROCEDURE V20230214143439__Create_PostgraduateManaStudDataprovider()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='POST_GRADUATE_MANAGEMENT_STUDENTS_INFO')) THEN 
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Post graduate Management Students', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='Post graduate Management Students');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'POST_GRADUATE_MANAGEMENT_STUDENTS_INFO', '1',null, '1', '1', 
"SELECT 
T4.id AS id,
T4.firstName AS student_first_name,
T4.middleName AS student_middle_name,
T4.lastName AS student_last_name,
T1.code as student_id,
T4.externalSysRefOne AS student_su_number,
T4.mobileNumber AS Student_mobile_no,
T4.emailId AS student_email_id,
T9.itemValue AS Year,
T5.programName AS program_name,
T5.fieldOfStudyLanguageTwo AS filed_of_study,
T6.doctoral_thesis AS dissertation_or_thesis_title,
T7.deptName AS supervisor_department
from users T1
left join students T2 on T2.userId=T1.id
left join  persons T4 on T4.id=T2.personId
left join admission T3 on T3.studentId=T2.personId
left join programs T5 on T5.id=T3.programId
left join batches T8 on T8.id =T3.batchId
left join intake_year T9 on T9.id= T8.intakeYearId
left join post_school_studies_section T6 on T6.persons_id=T2.personId
left join department T7 on T7.id=T5.programDepartmentId

",
    'PGM_USER_ID', 'student_first_name,student_middle_name,student_last_name,student_id,student_su_number,Student_mobile_no,student_email_id,Year,program_name,filed_of_study,dissertation_or_thesis_title,supervisor_department', 'where T1.id=PGM_USER_ID order by T6.id desc limit 1;','0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('student_first_name', 'Student First Name',@dydtdatalinitemId+1),
    ('student_middle_name', 'Student Middle Name',@dydtdatalinitemId+1),
    ('student_last_name', 'Student last Name',@dydtdatalinitemId+1),
    ('student_id', 'Student ID',@dydtdatalinitemId+1),
    ('student_su_number', 'Student SU Number',@dydtdatalinitemId+1),
    ('Student_mobile_no', 'Student Mobile No.',@dydtdatalinitemId+1),
    ('student_email_id', 'Student Email ID',@dydtdatalinitemId+1),
    ('Year', 'Year',@dydtdatalinitemId+1),
    ('program_name', 'Program Name',@dydtdatalinitemId+1),
    ('filed_of_study', 'Field of Study',@dydtdatalinitemId+1),
    ('dissertation_or_thesis_title', 'Dissertation/ Thesis Title',@dydtdatalinitemId+1),
    ('supervisor_department', 'Supervisor Department',@dydtdatalinitemId+1);
   
END IF; 

END $$
CALL V20230214143439__Create_PostgraduateManaStudDataprovider () $$ 
DROP PROCEDURE IF EXISTS V20230214143439__Create_PostgraduateManaStudDataprovider $$ 
DELIMITER ;