DELIMITER $$
DROP PROCEDURE IF EXISTS V20230329192731__Update_ExternalStudyLeaderDataProvider $$
CREATE PROCEDURE V20230329192731__Update_ExternalStudyLeaderDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_STUDY_LEADER_INFO')) THEN 
UPDATE dydt_data_line_item
SET whereClauseBindingDef = 'PRM_ADMISSION_ID', sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_study_leader_first_name,
T4.middleName AS external_study_leader_middle_name,
T4.lastName AS external_study_leader_last_name,
T4.alternateEmailId AS external_study_leader_alternative_email_id,
T4.emailId AS external_study_leader_email_id,
T4.phoneNo AS external_study_leader_telephone_no,
T4.mobileNumber AS external_study_leader_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as external_study_leader_address
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join person_functionary_details T3 on T3.personId=T2.personId
left join functionary_type on functionary_type.id=T3.functionaryTypeId 
left join staffs T5 on T5.userId=T3.functionaryUserId and functionary_type.itemCode='External Study Leader'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId"
,resultColumnsDef="external_study_leader_first_name,external_study_leader_middle_name,external_study_leader_last_name,external_study_leader_address,external_study_leader_email_id,external_study_leader_alternative_email_id,external_study_leader_telephone_no,external_study_leader_mobile_no",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and functionary_type.itemCode='External Study Leader' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'EXTERNAL_STUDY_LEADER_INFO';
END IF; 

IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_STUDY_LEADER_INFO')) THEN 
SET @dataProviderLineItemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='EXTERNAL_STUDY_LEADER_INFO');
UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_first_name'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader First Name';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_middle_name'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Middle Name';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_last_name'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Last Name';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_address'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Address';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_email_id'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Email ID';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_alternative_email_id'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Alternative Email ID';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_telephone_no'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Telephone No.';

UPDATE dydt_templateparams_translations SET `translationCode`='external_study_leader_mobile_no'
WHERE  dataProviderLineItemId= @dataProviderLineItemId AND translationValue = 'External Study Leader Mobile No.';

END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230329192731__Update_ExternalStudyLeaderDataProvider () $$
DROP PROCEDURE IF EXISTS V20230329192731__Update_ExternalStudyLeaderDataProvider $$
DELIMITER ;