DELIMITER $$
DROP PROCEDURE IF EXISTS V20230511144719__Insert_EmpHighQualiAwardingInst $$
CREATE PROCEDURE V20230511144719__Insert_EmpHighQualiAwardingInst()
BEGIN

-- DFR

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and  formFieldName ='highestQualification')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('personalinformationform','highestQualification','highestQualification','textfield',0,0,NULL,1,now(),'Highest Qualification','1','Personal Details Info','Create, Edit, and View','Highest Qualification',0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and  formFieldName ='awardingInstitution')) THEN 
INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
VALUES ('personalinformationform','awardingInstitution','awardingInstitution','textfield',0,0,NULL,1,now(),'Awarding Institution','1','Personal Details Info','Create, Edit, and View','Awarding Institution',0);
END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PERSON' and keyName = 'HIGHEST_QUALIFICATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON', 'HIGHEST_QUALIFICATION', 'Highest Qualification', 'Highest Qualification','Hoogste Kwalifikasie','chất lượng tốt nhất',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'PERSON' and keyName = 'AWARDING_INSTITUTION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('PERSON', 'AWARDING_INSTITUTION', 'Awarding Institution', 'Awarding Institution','Toekenningsinstelling','Tổ chức trao giải',now(),1);
END IF;

END $$
CALL V20230511144719__Insert_EmpHighQualiAwardingInst() $$
DROP PROCEDURE IF EXISTS V20230511144719__Insert_EmpHighQualiAwardingInst $$
DELIMITER ;