DELIMITER $$
DROP PROCEDURE IF EXISTS V20230525123534__Update_CommitteeConfLoader $$
CREATE PROCEDURE V20230525123534__Update_CommitteeConfLoader()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @masterId = (select id from import_utility_master WHERE code='bulkCommitteeCreation');
IF EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND 
table_name='loader_header' AND column_name='headerCode')) THEN 

update loader_header
set isNonEditable=1,isMandatory=1
where headerCode="FROM_DATE_HEADER" and defaultHeaderLabel="From Date" and importUtilityMasterId=@masterId;

update loader_header
set isNonEditable=1,isMandatory=1
where headerCode="TO_DATE_HEADER" and defaultHeaderLabel="To Date" and importUtilityMasterId=@masterId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230525123534__Update_CommitteeConfLoader () $$
DROP PROCEDURE IF EXISTS V20230525123534__Update_CommitteeConfLoader $$
DELIMITER ;