DELIMITER $$
DROP PROCEDURE IF EXISTS V20230622135822__Update_UWC_Translation $$
CREATE PROCEDURE V20230622135822__Update_UWC_Translation()
BEGIN

SET SQL_SAFE_UPDATES=0;
set @tempID = (select max(id) from report_template where templateCode='UWC_TRANSCRIPT' and templateName='UWC Transcript');

IF EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_THE_UNIVERSITY2') THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'The University is duly accredited by the Council on Higher Education and its degrees and diplomas are registered on the National Qualifications Framework in terms of the South African Qualifications Authority Act, No. 58 of 1995.' WHERE reportTemplateId = @tempID AND keyValue='TRANS_THE_UNIVERSITY2';
END IF;

IF EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_MEDIUM1') THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'MEDIUM/LANGUAGE OF INSTRUCTION' WHERE reportTemplateId = @tempID AND keyValue='TRANS_MEDIUM1';
END IF;
SET SQL_SAFE_UPDATES=1;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId=  @tempID and keyValue='TRANS_ENGLISH')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@tempID, 'TRANS_ENGLISH', 'ENGLISH', '1', NOW());

END IF;

END $$
CALL V20230622135822__Update_UWC_Translation () $$
DROP PROCEDURE IF EXISTS V20230622135822__Update_UWC_Translation $$
DELIMITER ;